extends Node2D

@onready var clip_area: Polygon2D = $ClipArea
@onready var clipable_body: ClipableBody = $ClipableBody
@onready var line_2d: Line2D = $Line2D

var polygon: Array[Vector2] = []
var start_point: Vector2
var selecting_point = false

func _input(event: InputEvent):
	if event.is_action_pressed("click"):
		var mouse_position = get_global_mouse_position()
		if not selecting_point:
			# 开始选点
			polygon = []
			start_point = mouse_position
			selecting_point = true
			clip_area.hide()
			line_2d.show()
		if polygon.size() >= 3 and (start_point - mouse_position).length() < 5:
			# 结束选取
			clip_area.polygon = PackedVector2Array(polygon)
			clip_area.show()
			line_2d.hide()
			selecting_point = false
			# 切割
			clipable_body.clip_shape(PackedVector2Array(polygon))
		else:
			# 添加一个点
			polygon.push_back(mouse_position)
			line_2d.points = PackedVector2Array(polygon)
